package img;

import java.awt.Color;

/**
 * Transformation : applique un <i>filtre</i> sur l'image.
 * <p>
 * 
 * Un filtre est une transformation qui a pour effet la modification des
 * <i>valeurs</i> de pixels. Il ne modifie pas les dimensions de l'image.
 */
public class Filtre extends Transformation {

	/**
	 * Fonction utilitaire de normalisation de valeur de couleur.
	 * <p>
	 * 
	 * Cette fonction permet de recaler une valeur flottante résultant d'un calcul
	 * sur des couleurs de pixels dans l'intervalle {0, ..., 255} des valeurs
	 * entières admises.
	 * <p>
	 * Le paramètre de cette fonction est un double dont on ne garde que la partie
	 * entière. Si cette partie entière est négative, elle est assimilée 0. Si elle
	 * est supérieure à 255, elle est assimilée à 255.
	 * 
	 * @param d valeur à normaliser
	 * @return valeur de d normalisée
	 */
	protected static int normalise(double d) {
		int nd = (int) d;
		return (nd < 0 ? 0 : (nd > 255 ? 255 : nd));
	}

	/**
	 * Fonction générale de transformation d'un pixel.
	 * <p>
	 * Le pixel transformé est extrait du tableau fourni. Il est désigné par ses
	 * coordonnées dans ce tableau. Le pixel résultant de la transformation peut
	 * dépendre selon les cas de ce seul pixel ou de ce pixel et de son voisinage.
	 * 
	 * @param pixels tableau contenant le pixel à transformer
	 * @param x      abscisse du pixel à transformer
	 * @param y      ordonnée du pixel à transformer
	 * @return pixel transformé
	 */
	protected Color transformePixel(Color[][] pixels, int y, int x) {
		// Cette méthode a vocation à être redéfinie dans les sous-classes.
		return pixels[y][x]; // par défaut, la transformation fournit le pixel inchangé
	}

	/**
	 * Applique une fonction de transformation sur tous les pixels de l'image.
	 * <p>
	 * 
	 * La fonction crée un nouveau tableau en appliquant la méthode transformePixel
	 * à tous les pixels du tableau fourni.
	 * 
	 * @param pixels tableau source
	 * @return nouveau tableau obtenu par application de transformePixel
	 */
	@Override
	protected Color[][] transforme(Color[][] pixels) {
		// TODO EXERCICE 4 : à compléter...
		return null; // <- TODO résultat à adapter
	}

}
